
-- migrate niota metadata from a side by side release current; 
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.07.08
-- 
-- migrate niota metadata from a previous release to current
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.09.04  rre      add comment and header
--
-- *******************************************************************************


USE niota_meta;

call mdConfig_MigrateSimple_V2('V20_2_V20', '[CONNECTION]', '%', @null);
call mdConfig_MigrateSimple_V2('V20_2_V20', '[CONSTRAINT]', '%', @null);
call mdConfig_MigrateSimple_V2('V20_2_V20', '[USER]', '%', @null);
call mdConfig_MigrateSimple_V2('V20_2_V20', '[USERGROUP]', '%', @null);
call mdConfig_MigrateSimple_V2('V20_2_V20', '[GROUPMEMBER]', '%', @null);
call mdConfig_MigrateSimple_V2('V20_2_V20', '[CALLABLE]', '%', @null);
call mdConfig_MigrateSimple_V2('V20_2_V20', '[LOGGING]', '%', @null);
call mdConfig_MigrateSimple_V2('V20_2_V20', '[CATALOG]', '%', @null);
call mdConfig_MigrateSimple_V2('V20_2_V20', '[TRANSACTION]', '%', @null);
call mdConfig_MigrateSimple_V2('V20_2_V20', '[MENU]', '%', @NULL);

-- TRUNCATE TABLE niota_meta.etx_useraction;
INSERT INTO niota_meta.etx_useraction
(
ts_log, id_session, db_name, object, catalog_id, instance_name, `action`, username, command
)
SELECT ts_log, id_session, db_name, object, catalog_id, instance_name, `action`, username, command
FROM niota_mdv20.etx_useraction;


INSERT INTO niota_meta.etx_catalog_object_config 
(
 appcode_cfg,
 catalog_id,
 cfg_id, 
 cfg_value, 
 description
)
SELECT 
 appcode_cfg, 
 catalog_id, 
 cfg_id, 
 cfg_value, 
 description
FROM niota_mdv20.etx_catalog_object_config srctbl
WHERE appcode_cfg <> 'nitoa'
ON DUPLICATE KEY UPDATE  
 appcode_cfg = srctbl.appcode_cfg, 
 catalog_id = srctbl.catalog_id, 
 cfg_id = srctbl.cfg_id, 
 cfg_value = srctbl.cfg_value, 
 description = srctbl.description
; 
 
INSERT INTO niota_meta.etx_user_config 
(
 appcode_cfg,
 username,
 cfg_id, 
 cfg_value, 
 description
)
SELECT 
 appcode_cfg, 
 username, 
 cfg_id, 
 cfg_value, 
 description
FROM niota_mdv20.etx_user_config srctbl
WHERE appcode_cfg <> 'nitoa'
ON DUPLICATE KEY UPDATE  
 appcode_cfg = srctbl.appcode_cfg, 
 username = srctbl.username, 
 cfg_id = srctbl.cfg_id, 
 cfg_value = srctbl.cfg_value, 
 description = srctbl.description
; 
 
INSERT INTO niota_meta.etx_system_config 
(
 appcode_cfg,
 cfg_id, 
 cfg_value, 
 description
)
SELECT 
 appcode_cfg,  
 cfg_id, 
 cfg_value, 
 description
FROM niota_mdv20.etx_system_config srctbl
WHERE appcode_cfg <> 'niota'
ON DUPLICATE KEY UPDATE  
 appcode_cfg = srctbl.appcode_cfg, 
 cfg_id = srctbl.cfg_id, 
 cfg_value = srctbl.cfg_value, 
 description = srctbl.description
; 

INSERT INTO niota_meta.etx_sequence 
(
 appcode_seq, 
 seq_id, 
 seq_value_increment, 
 seq_value_min, 
 seq_value_max, 
 seq_value_cur, 
 ind_cycle
)
SELECT 
 appcode_seq, 
 seq_id, 
 seq_value_increment, 
 seq_value_min, 
 seq_value_max, 
 seq_value_cur, 
 ind_cycle
FROM niota_mdv20.etx_sequence srctbl
WHERE appcode_seq <> 'niota'
ON DUPLICATE KEY UPDATE  
 appcode_seq = srctbl.appcode_seq, 
 seq_id = srctbl.seq_id, 
 seq_value_increment = srctbl.seq_value_increment, 
 seq_value_min = srctbl.seq_value_min,
 seq_value_max = srctbl.seq_value_max, 
 seq_value_cur = srctbl.seq_value_cur, 
 ind_cycle = srctbl.ind_cycle 
; 
 
INSERT INTO niota_meta.etx_message_text 
(
 appcode_msg, 
 msg_id, 
 lang_msg, 
 type_msg, 
 ind_stop_msg, 
 text_msg
)
SELECT 
 appcode_msg, 
 msg_id, 
 lang_msg, 
 type_msg, 
 ind_stop_msg, 
 text_msg
FROM niota_mdv20.etx_message_text srctbl
WHERE appcode_msg <> 'niota'
ON DUPLICATE KEY UPDATE  
 appcode_msg = srctbl.appcode_msg, 
 msg_id = srctbl.msg_id, 
 lang_msg = srctbl.lang_msg, 
 type_msg = srctbl.type_msg,
 ind_stop_msg = srctbl.ind_stop_msg, 
 text_msg = srctbl.text_msg 
; 
  
-- some test SQL statements


-- select * from et_user_parameter where param_name = 'admin_menu_state';
-- delete from et_user_paramter where param_name = 'admin_menu_state';
--
-- call mdConfig_MigrateSimple('Vxx15_2_V20', '[XXX]', '%', 'root');

-- 