DELIMITER $$
CREATE DEFINER=`niota`@`%` PROCEDURE `mdConfig_SortOrder`(
  IN CMDSYP_I        nvarchar(16)  -- CoMmanD SYstem Procedure           
 ,IN OPTSYP_I        nvarchar(128) -- OPTion SYstem Procedure
 ,IN ID_I            nvarchar(32)  -- ID to handle                
)
this_sp: BEGIN
-- drop procedure if exists `mdConfig_SortOrder`
--
-- -- how to test --
-- call mdConfig_SortOrder('SETPRIO', 'CATALOG', '16040');
--
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.06.30
-- 
-- set/change sort prio for given ID
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.06.30   fmrre    add comment and header
--
-- *******************************************************************************
--	

declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare sep_sp varchar(01) default mdinfo_SysConstant('SEP_SYPPAR');

declare l_this_sp nvarchar(128) default 'mdConfig_SortOrder';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_SP_ERR');
declare l_msg_par_final nvarchar(4000) default ' ';
declare l_message_text varchar(128) default ' ';
declare l_appcode varchar(5) default mdinfo_SysConstant('APPCODE');
declare l_cfg_id_maxnbr varchar(32) default 'NBR_PRIORIZED_MD_ENTRIES';


declare l_cmdsyp nvarchar(16);
declare l_ind_cmdsyp bit default 0;

declare l_cmdsyp_setprio nvarchar(16) default 'SETPRIO';
declare l_ind_cmdsyp_setprio bit default 0;

-- all possible system options
declare l_optsyp_catalog nvarchar(16) default 'CATALOG_ID';
declare l_ind_optsyp_catalog bit default 0;

declare l_optsyp_withuca nvarchar(16) default 'WITHUCA';
declare l_ind_optsyp_withuca bit default 0;

declare l_optsyp nvarchar(128);
declare l_ind_optsyp bit default 0;

declare l_alloptsyp nvarchar(512);
declare l_allcmdsyp nvarchar(512);

-- internal strings (e.g. logging command and its options)
declare l_cmd_log varchar(16) default "LOG";
declare l_opt_cmdlog varchar(128) default "";

declare l_param_id integer;
declare l_username_param varchar(32) default mdinfo_SysConstant('USERGROUPNAME_ALLGROUP');
declare l_param_name varchar(256) default 'prioritized_md_entry';
declare l_param_value varchar(256) default ' ';
declare l_param_filter_01 varchar(128) default ' ';
declare l_param_filter_02 varchar(128) default ' ';

declare l_username nvarchar(16) default '';

declare l_id nvarchar(32);
declare l_nbr_setprio integer default 0;
declare l_max_setprio integer default 10;
declare l_nxt_setprio integer default 0;

declare l_ind_insertprio bit default 0;
declare l_ind_deleteprio bit default 0;
declare l_ind_updateprio bit default 0;

--
-- cursor columns
-- no cursor needed
--
  
set l_cmdsyp = CMDSYP_I;
set l_optsyp = OPTSYP_I;

-- set indicators for syscommand to true if the string is found in den CMDSYP-Parameter;
if locate(l_cmdsyp_setprio, l_cmdsyp, 1) > 0 then set l_ind_cmdsyp_setprio = 1; end if;

-- check if at least one command is valid
set l_ind_cmdsyp = l_ind_cmdsyp_setprio; -- | next;
set l_allcmdsyp = concat(l_cmdsyp_setprio); -- next

-- set indicators for sysoptions to true if the string is found in den OPTSYP-Parameter;
if locate(l_optsyp_catalog, l_optsyp, 1) > 0 then set l_ind_optsyp_catalog = 1; end if;
if locate(l_optsyp_withuca, l_optsyp, 1) > 0 then set l_ind_optsyp_withuca = 1; end if;

-- check if at least one option is valid
set l_ind_optsyp = l_ind_optsyp_catalog | l_ind_optsyp_withuca; -- | next;
set l_alloptsyp = concat(l_optsyp_catalog, sep_sp, l_optsyp_withuca); -- next

main: begin
if l_ind_cmdsyp = 0 then set l_msg_par_final = concat(l_cmdsyp, sep_mp, l_allcmdsyp); leave main; end if;
if l_ind_optsyp = 0 then set l_msg_par_final = concat(l_optsyp, sep_mp, l_alloptsyp); leave main; end if;

-- forward the withuca - option to internal logging
if l_ind_optsyp_withuca then set l_opt_cmdlog = l_optsyp_withuca; end if;

 INSERT INTO etx_log(poster_log, logtext) select l_optsyp, l_optsyp_withuca;
-- retrieve the web-userid from the WITHUCA-String WITHUCA(username)
set l_username = coalesce(mdInfo_OptionConfigValue(l_optsyp, l_optsyp_withuca),  substring(current_user(),1,16));
 INSERT INTO etx_log(poster_log, logtext) select 'l_username', l_username;
 
set l_id = id_i;
set l_max_setprio = mdInfo_SysConfigValue(l_appcode, l_cfg_id_maxnbr);
 
setprio: begin
if not l_ind_cmdsyp_setprio then leave setprio; end if;

-- use option - string for param-filter 
if l_ind_optsyp_catalog then
   set l_param_filter_01 = l_optsyp_catalog;
end if;

select 
   count(*)
into 
   l_nbr_setprio
from et_user_parameter
where username = l_username_param 
 and param_name = l_param_name
 and param_filter_01 = l_param_filter_01;

-- INSERT INTO etx_log(poster_log, logtext) select 'nbr_setprio:', l_nbr_setprio;
-- INSERT INTO etx_log(poster_log, logtext) select 'max_setprio:', l_max_setprio;

-- insert a record
if l_nbr_setprio < l_max_setprio then
   set l_nxt_setprio = l_nbr_setprio + 1;
   set l_ind_insertprio = 1;
end if;

-- delete all settings greater then max
if l_nbr_setprio > l_max_setprio then
   delete 
   from et_user_parameter
   where username = l_username_param 
    and param_name = l_param_name
    and param_filter_01 = l_param_filter_01
    and param_filter_02 > lpad((l_max_setprio),2,'0');
   set l_ind_updateprio = 1; 
--   INSERT INTO etx_log(poster_log, logtext) select 'nbr_setprio:', l_nbr_setprio;
end if;

if l_nbr_setprio = l_max_setprio then
   set l_ind_updateprio = 1; 
end if;

insert_prio: BEGIN
if not l_ind_insertprio then leave insert_prio; end if;

set l_param_value = lpad((l_max_setprio - l_nbr_setprio),2,'0');
set l_param_filter_02 = lpad((l_nxt_setprio),2,'0'); 

-- INSERT INTO etx_log(poster_log, logtext) select l_username_param, concat(l_param_name, l_param_filter_01, l_param_filter_02, l_id);
-- INSERT INTO etx_log(poster_log, logtext) select l_poster_log, l_ind_optsyp;

insert into niota_meta.et_user_parameter 
(username, param_name, param_value, param_filter_01, param_filter_02, param_filter_03, param_filter_04, param_filter_05)
values 
(l_username_param, l_param_name, l_param_value, l_param_filter_01, l_param_filter_02, l_id, current_timestamp, null);

END insert_prio;

update_prio: BEGIN
if not l_ind_updateprio then leave update_prio; end if;

-- read the oldest entry (by time)
select 
  param_id
 into
  l_param_id  
from niota_meta.et_user_parameter
where username = l_username_param
  and param_name = l_param_name
  and param_filter_01 = l_param_filter_01
order by param_filter_04, param_value desc 
limit 1;

-- set new value to oldest value (using ID) set sort number to 1
update niota_meta.et_user_parameter
 set 
  param_value = '01',
  param_filter_03 = l_id,
  param_filter_04 = current_timestamp
where param_id = l_param_id;

-- increment all the other sortnumbers up
update niota_meta.et_user_parameter
  set param_value = lpad((param_value + 1),2,'0')
where username = l_username_param
  and param_name = l_param_name
  and param_filter_01 = l_param_filter_01
  and param_id <> l_param_id;

END update_prio;


if l_ind_insertprio then
   set l_msg_id_final = 1071;
   set l_msg_par_final = concat(l_id, sep_mp, l_param_name, sep_mp, l_param_filter_01);
end if;

if l_ind_updateprio then
   set l_msg_id_final = 1072;
   set l_msg_par_final = concat(l_id, sep_mp, l_param_name, sep_mp, l_param_filter_01);
end if;

end setprio;
end main;

call mdLog_UserMessage(l_cmd_log, l_opt_cmdlog, l_username, l_this_sp, l_msg_id_final, l_msg_par_final, l_message_text);

if l_ind_cmdsyp = 0 or l_ind_optsyp = 0 then 
   SIGNAL SQLSTATE '45000'
   SET MESSAGE_TEXT = l_message_text;
end if;

end$$
DELIMITER ;
