-- select mdLookup_SortOrder('catalog_id', x.catalog_id) as sort_id, x.* from niota_meta.et_catalog_object x order by sort_id 

DELIMITER //
CREATE DEFINER=`niota`@`%` FUNCTION `mdLookup_SortOrder`(
	`infotype_i` VARCHAR(16),
	`id_i` varchar(128)


) RETURNS varchar(128) CHARSET utf8mb3
    DETERMINISTIC
BEGIN
--
-- use niota_meta
-- drop function if exists `mdLookup_SortOrder`
--
-- -- how to test --
-- select mdLookup_SortOrder('catalog_id', x.catalog_id) as sort_id, x.* from niota_meta.et_catalog_object x order by sort_id
--
--
-- *******************************************************************************
-- author.........: Reinhard Reisinger
-- copyright......: ritconsult IT und Projektconsulting Ges.m.b.H.
-- date written...: 2020.05.20
-- 
-- get an alternative sort-value for a catalog id and ....
-- ===========+========+===== changelog ==========================================
-- YYYY.MM.DD | author | change
-- -----------+--------+----------------------------------------------------------
-- 2020.05.12   rre     add comment and header
--
-- *******************************************************************************

declare rownumber bigint default 0;
declare sep_mp varchar(01) default mdinfo_SysConstant('SEP_MSGPAR');
declare this_udf varchar(32) default 'mdLookup_SortOrder';
declare l_msg_id_final integer default mdinfo_SysConstant('MSG_ID_UDF_ERR');
declare l_msg_par_final nvarchar(4000) default ' ';
declare l_message_text varchar(128) default ' '; 

declare l_username varchar(32) default mdinfo_SysConstant('USERGROUPNAME_ALLGROUP');
declare l_param_name varchar(256) default 'prioritized_md_entry';


declare sortvalue varchar(128) default null;

declare l_infotype varchar(16);
declare l_catalog_id_c nvarchar(10);
declare l_param_filter_03 nvarchar(128);
declare l_param_value nvarchar(256);

function_block: BEGIN
set l_infotype = infotype_i;

if upper(l_infotype) not in ('CATALOG_ID') then
   set l_message_text = concat('invalid infotype', sep_mp, l_infotype);
   leave function_block;
end if;

catalog: BEGIN
set l_catalog_id_c = substring(id_i, 1, 10);

select 
 param_value
into 
 l_param_value
from niota_meta.et_user_parameter
where username = l_username 
and param_name = l_param_name
and param_filter_01 = l_infotype
and param_filter_03 = l_catalog_id_c
limit 1;

if row_count() <> 0 then
   set sortvalue = lpad(substr(trim(l_param_value), 1, 2),9,'0');
 else 
   set sortvalue = '999999999';
end if;

set l_msg_id_final = 0;
leave function_block; 
END catalog;


END function_block;

if l_msg_id_final = 0 then
   return(sortvalue);
else
  call mdLog_UserMessage(l_cmdlog_get, l_opt_cmdlog, current_user, this_udf, l_msg_id_final, l_msg_par_final, l_message_text);
  
  SIGNAL SQLSTATE '45000'
  SET MESSAGE_TEXT = l_message_text;
end if;


END//
DELIMITER ;


