-- use <myDB>
go

--
-- user communication area
-- 
-- drop table if exists([dbo].[et_user_comm_area]);

CREATE TABLE [dbo].[et_user_comm_area](
   username varchar(16) NOT NULL,
   appcode  varchar(5) NOT NULL,
   id_session  varchar(32) NOT NULL,
   guid_msg  varchar(32) DEFAULT NULL,
   lang  varchar(2) NOT NULL,
   uca  varchar(512) DEFAULT NULL,
 CONSTRAINT [PK_et_user_comm_area] PRIMARY KEY CLUSTERED 
(
	[username] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
GO

-- 
-- standard messageing table 
--
-- drop table if exists([dbo].[etx_message]);
CREATE TABLE etx_message (
  id_log int IDENTITY(1,1) NOT NULL,
  ts_log datetime not null DEFAULT getdate(),
  ts_msg_ui datetime NULL,
  id_session varchar(32) NULL,
  guid_msg varchar(32) NOT NULL,
  type_msg varchar(3) NULL,
  text_msg varchar(2000) NULL,
  username varchar(16) NULL,
  poster_be varchar(128) NULL,
  username_be varchar(16) NULL,
  ind_stop_msg smallint not null DEFAULT 0,
  par_msg_1 varchar(256) NULL,
  par_msg_2 varchar(256) NULL,
  par_msg_3 varchar(256) NULL,
  par_msg_4 varchar(256) NULL,
  par_msg_5 varchar(256) NULL,
  par_msg_6 varchar(256) NULL,
  par_msg_7 varchar(256) NULL,
  par_msg_8 varchar(256) NULL,
  par_msg_9 varchar(256) NULL,
CONSTRAINT [PK_etx_message] PRIMARY KEY CLUSTERED 
(
	[id_log] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, OPTIMIZE_FOR_SEQUENTIAL_KEY = OFF) ON [PRIMARY]
) ON [PRIMARY]
;
go

